--
-- SPDX-License-Identifier: BSD-2-Clause-FreeBSD
--
-- Copyright (c) 2015 Pedro Souza <pedrosouza@freebsd.org>
-- All rights reserved.
--
-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions
-- are met:
-- 1. Redistributions of source code must retain the above copyright
--    notice, this list of conditions and the following disclaimer.
-- 2. Redistributions in binary form must reproduce the above copyright
--    notice, this list of conditions and the following disclaimer in the
--    documentation and/or other materials provided with the distribution.
--
-- THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
-- ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
-- IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
-- ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
-- FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
-- DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
-- OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
-- HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
-- LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
-- OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
-- SUCH DAMAGE.
--
-- $FreeBSD: releng/12.0/stand/lua/screen.lua 338108 2018-08-20 16:44:09Z imp $
--

local color = require("color")
local core = require("core")

local screen = {}

-- Module exports
screen.default_x = 0
screen.default_y = 25

function screen.clear()
	printc(core.KEYSTR_CSI .. "H" .. core.KEYSTR_CSI .. "J")
end

function screen.setcursor(x, y)
	printc(core.KEYSTR_CSI .. y .. ";" .. x .. "H")
end

function screen.setforeground(color_value)
	if color.disabled then
		return color_value
	end
	printc(color.escapefg(color_value))
end

function screen.setbackground(color_value)
	if color.disabled then
		return color_value
	end
	printc(color.escapebg(color_value))
end

function screen.defcolor()
	printc(color.default())
end

function screen.defcursor()
	screen.setcursor(screen.default_x, screen.default_y)
end

return screen
